//
//  GSAxis.h
//  GlyphsCore
//
//  Created by Martin Winter on 11.05.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>

#ifndef GLYPHS_LITE
#ifndef LIBCORE
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif
#endif

@class GSFont;
@class GSMetricValue;

NS_ASSUME_NONNULL_BEGIN

// Convenience type definition.
typedef NSString *GSAxisTag NS_EXTENSIBLE_STRING_ENUM;

typedef NSMutableDictionary<NSString *, GSMetricValue *> GSAxisValues;

extern GSAxisTag GSAxisTagEngr;
extern GSAxisTag GSAxisTagHght;
extern GSAxisTag GSAxisTagItal;
extern GSAxisTag GSAxisTagOpsz;
extern GSAxisTag GSAxisTagOtln;
extern GSAxisTag GSAxisTagRefl;
extern GSAxisTag GSAxisTagRsec;
extern GSAxisTag GSAxisTagRxad;
extern GSAxisTag GSAxisTagRyad;
extern GSAxisTag GSAxisTagShdw;
extern GSAxisTag GSAxisTagSlnt;
extern GSAxisTag GSAxisTagUdln;
extern GSAxisTag GSAxisTagVotf;
extern GSAxisTag GSAxisTagVrot;
extern GSAxisTag GSAxisTagWdth;
extern GSAxisTag GSAxisTagWght;
extern GSAxisTag GSAxisTagXopq;
extern GSAxisTag GSAxisTagXtab;
extern GSAxisTag GSAxisTagXtch;
extern GSAxisTag GSAxisTagXtra;
extern GSAxisTag GSAxisTagYopq;
extern GSAxisTag GSAxisTagYtas;
extern GSAxisTag GSAxisTagYtch;
extern GSAxisTag GSAxisTagYtde;
extern GSAxisTag GSAxisTagYtfg;
extern GSAxisTag GSAxisTagYtlc;
extern GSAxisTag GSAxisTagYtra;
extern GSAxisTag GSAxisTagYtse;
extern GSAxisTag GSAxisTagYtuc;
extern GSAxisTag GSAxisTagYtfi;
extern GSAxisTag GSAxisTagRond;

#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
/**
 `GSAxis` represents an axis in a `GSFont` object.

 @attention This class is not to be confused with the `GXAxis` class!
 */
@interface GSAxis : NSObject <GSIdentifiableParameter>
#else
@interface GSAxis : NSObject
#endif

/**
 Convenience initializer (the properties are mutable after initialization).
 */
- (instancetype)initWithName:(NSString *)name tag:(nullable GSAxisTag)tag;

- (instancetype)initWithDict:(NSDictionary *)axisDict format:(GSFormatVersion)formatVersion;

- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

@property (nonatomic, weak) GSFont *parent;

/**
 The human-readable axis name.
 */
@property (nonatomic, copy) NSString *name;

/**
 A four-letter tag representing the axis type.

 @attention This property can not be called `tag` as this conflicts with multiple existing properties/methods of the same name but type `NSInteger`. This would lead to build errors when accessing this property on objects of type `id`.
 */
@property (nullable, nonatomic, strong) GSAxisTag axisTag;

- (nonnull NSString *)axisTagDefault;

/// shorter axisTag for UI purposes
- (NSString *)shortAxisTag;

@property (nonatomic) BOOL hidden;

@property (nonatomic, strong) NSString *axisId;

/**
 For variation axes, this is the default value.

 @note Minimum and maximum values are not currently accessed, so there are no properties for them yet.

 @attention This property can not be called `default` as this conflicts with a reserved keyword.
 */
@property (nonatomic) CGFloat defaultValue;

+ (NSArray *)defaultAxisTags;

+ (NSDictionary *)axisTagToNameMapping;

+ (NSDictionary *)axisNameToTagMapping;
/**
 TODO: Add documentation

 @attention This property can not be called `default` as this conflicts with a reserved keyword.
 */
@property (nonatomic) BOOL isDefault;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;
#endif

+ (NSArray<GSAxis *> *)cornerAxes;

+ (nullable NSDictionary *)axisIdToTags:(NSDictionary *)region axes:(NSArray *)axes;

+ (nullable NSDictionary *)filterEmptyRegions:(NSDictionary *)region;
@end

NS_ASSUME_NONNULL_END
